/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8238.DeviceView;

import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicImage;
import ibm.nways.jdm.I18NString;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm8238.DeviceView.ChassisInfoLike;
import ibm.nways.jdm8238.DeviceView.ChassisLike;
import ibm.nways.jdm8238.DeviceView.TrunkPortLike;
import ibm.nways.jdm8238.MibValue;
import ibm.nways.ras.RAS;
import java.awt.Point;
import java.io.Serializable;
import java.util.ResourceBundle;

public abstract class TrunkPort
implements TrunkPortLike {
    public GenModel portTableModel;
    public ModelInfo portModelInfo;
    public int lobeIndex;
    public int moduleIndex;
    protected GraphicImage portGraphicImage;
    protected int portType;
    protected Point location;
    protected GraphicContainer graphicContainer;
    protected GraphicContainer portContainer = new GraphicContainer();
    protected static final String BUNDLE_NAME = "ibm.nways.jdm8238.DeviceView.GraphicResources";
    protected static ResourceBundle resources = ResourceBundle.getBundle("ibm.nways.jdm8238.DeviceView.GraphicResources");
    protected static final String DEST_PANEL = "ibm.nways.jdm8238.eui.TrunkPanel";
    protected static final int COOKIE_FLAGS = 16;
    protected String cookieID;
    protected JdmBrowser jdmBrowser;
    protected ChassisLike chassis;
    protected ChassisInfoLike chassisInfo;
    protected static final String[] PORT_TYPE = new String[]{"Port_backplane", "Port_fiber", "Port_rj45", "Port_Intrastack"};
    protected static final String[] TRUNK_TYPE = new String[]{"trunk_unknown", "trunk_unknown", "trunk_unknown", "trunk_ringIn", "trunk_ringOut", "trunk_unknown", "trunk_backplaneIn", "trunk_backplaneOut", "trunk_intraStackIn", "trunk_intraStackOut"};
    public static final int BACKPLANE = 1;
    public static final int FIBER = 5;
    public static final int RJ45S = 9;
    public static final int INTRASTACK = 25;
    protected static final String SER_PATH = "ibm.nways.jdm8238.WCDefault";

    public void dispose() {
        if (this.graphicContainer != null) {
            this.graphicContainer.dispose();
            this.graphicContainer = null;
        }
        if (this.portContainer != null) {
            this.portContainer.dispose();
            this.portContainer = null;
        }
        this.portGraphicImage = null;
        this.location = null;
        resources = null;
        this.portTableModel = null;
        this.jdmBrowser = null;
        this.chassisInfo = null;
    }

    public void draw() {
        this.graphicContainer.add(this.portContainer);
    }

    public GenModel getModel() {
        return this.portTableModel;
    }

    public ModelInfo getModelInfo() {
        try {
            this.portModelInfo = this.portTableModel.getInfo("Panel", "default", this.portModelInfo);
        }
        catch (Exception exception) {
            RAS.logException(19, 5, this, "getModelInfo", exception);
        }
        return this.portModelInfo;
    }

    public String getDestinationPanel() {
        return DEST_PANEL;
    }

    public final void setCommonInformation(ChassisLike chassisLike, ChassisInfoLike chassisInfoLike, JdmBrowser jdmBrowser, GenModel genModel, ModelInfo modelInfo, int n, int n2, GraphicContainer graphicContainer) {
        this.jdmBrowser = jdmBrowser;
        this.chassis = chassisLike;
        this.chassisInfo = chassisInfoLike;
        this.portTableModel = genModel;
        this.portModelInfo = modelInfo;
        this.moduleIndex = n;
        this.lobeIndex = n2;
        this.graphicContainer = graphicContainer;
    }

    public void setSpecificInformation() {
    }

    public final void setLocation(Point point) {
        this.location = point;
        this.portContainer.setLocation(this.location.x, this.location.y);
    }

    public String getFlyOverText() {
        Object object;
        int n = 0;
        Serializable serializable = this.chassisInfo.getMibInfo().getVar("trunkType", "." + this.moduleIndex + "." + this.lobeIndex);
        if (serializable instanceof MibValue) {
            object = (MibValue)serializable;
            n = (Integer)((MibValue)object).getValue();
        }
        object = TRUNK_TYPE[n];
        String string = new I18NString(BUNDLE_NAME, (String)object).getTranslation();
        return string;
    }
}

